﻿# #####################################################################
# Description: Windows 10 - Optimisation of Windows 1O Operating      #
# System for a VDI Environment                                        #
#                                                                     #
# AUTHOR: Alexander Zuber                                             #
#                                                                     #
# EMAIL: admin@thegeekfreaks.de                                       #
# DATE:  03/05/2018                                                   #
# VERSION: 2.0                                                        #
# VERSION HISTORY                                                     #
#    1.0 - 28/04/17 - Inital Optimisaiton Script                      #
#    1.1 - 01/0/17 - Updated type and additional task schedules       #
# #####################################################################
#Script Variables:
#The following Windows Services are optional and should be set to true if they are required based on your own environment
$AppMgmt = "True" # Applicaiton Management Services, if using GPO for Software Distribution please set to true
$BranchCache = "False"
$BITS = "True" # Requirement mainly by SCCM/AppSense
$Cortana = "False"
$DiagnosticService = "False"
$EAPService = "False"
$EFS = "False"
$FileHistoryService = "False"
$iSCSI = "False"
$MachPass = "True"
$MSSignInService = "True"
$AllowOneDrive = "True"
$PeerCache = "False"
$Search = "True"
$Themes = "True"
$Touch = "False"
$HyperVServices = "false"
$WindowsDefender = "false"
$ShowQuickAccess = "True"
$ShowNetworkIcon = "False"
$ShowAdmintools = "True"
$ShowCmdandPowershell = "True"
# Get list of Provisioned Start Screen Apps
$Apps = Get-ProvisionedAppxPackage -Online
#
$StartMenuApps = "False"

#Script Start Warning message and Pause before running
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                             WINDOWS 10 VDI OPTIMISATION SCRIPT                                *" -ForegroundColor Yellow
Write-Host "*                            ===================================                                *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*      THIS SCRIPT MAKES CONSIDERABLE CHANGES TO THE DEFAULT CONFIGURATION OF WINDOWS.          *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*       THIS SCRIPT WILL PERFORM A REBOOT UPON COMPLETION, PLEASE ENSURE DATA IS SAVED          *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*           PLEASE RUN AT YOUR OWN RISK AND IN A NON-PRODUCTION ENVIRONMENT FIRST               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
pause
# Remove Windows Features

If ($WindowsDefender -eq "False")
{
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                           DISABLING WINDOWS DEFENDER & SECURITY CENTRE                        *" -ForegroundColor Yellow
Write-Host "*                          =============================================                        *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
    Write-Host "" -ForegroundColor Cyan
    Write-Host "" -ForegroundColor Cyan
    Write-Host "" -ForegroundColor Cyan
    Write-Host "Disabling Antivirus/AntiSpyware.." -ForegroundColor Cyan
    reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender" /v DisableAntiSpyware /t REG_DWORD /d 0x1 /f  # Defender - NOTE - Only Remove if being replaced by another AV Product
    Write-Host "Disabling Windows Security Centre on Startup.." -ForegroundColor Cyan
    reg add HKLM\SYSTEM\CurrentControlSet\Services\SecurityHealthService /v Type /t REG_DWORD /d 0x3 /f #Set Windows Defender Security Centre
    Write-Host "==========================REMOVING OF WINDOWS DEFENDER COMPLETE==============================" -ForegroundColor Green
}
#Remove In-built Apps
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                            REMOVING BUILT-IN MICROSOFT APPLICAIOTNS                           *" -ForegroundColor Yellow
Write-Host "*                            ========================================                           *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
If ($StartMenuApps -eq "False")
{   
    Write-Host "Removing Candy Crush App..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "king.com*"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Twitter App..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*Twitter"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Duolingo App..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*Duolingo*"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Eclipse App..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*Eclipse*"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Remote Desktop App..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*RemoteDesktop*"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Adobe Photoshop..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*Photoshop*"} | Remove-AppxPackage | Out-Null
    Write-Host "Removing Bing News..." -ForegroundColor Green
    Get-AppxPackage -AllUsers | Where-Object {$_.Name -like "*Bing*"} | Remove-AppxPackage | Out-Null

    ForEach ($App in $Apps)
    {
        If ($App.DisplayName -eq "Microsoft.BingFinance")
        {
            Write-Host "Removing Finance App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.BingNews")
        {
            Write-Host "Removing News App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Start-Sleep 3
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.BingSports")
        {
            Write-Host "Removing Sports App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.Getstarted")
        {
            Write-Host "Removing Get Started App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.SkypeApp")
        {
            Write-Host "Removing Get Skype App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.MicrosoftOfficeHub")
        {
            Write-Host "Removing Get Office App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.XboxApp")
        {
            Write-Host "Removing XBox App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.ZuneMusic")
        {
            Write-Host "Removing Groove Music App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.ZuneVideo")
        {
            Write-Host "Removing Movies & TV App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.MicrosoftSolitaireCollection")
        {
            Write-Host "Removing Microsoft Solitaire Collection App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.3DBuilder")
        {
            Write-Host "Removing 3D Builder App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.People")
        {
            Write-Host "Removing People App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.Windows.Photos")
        {
            Write-Host "Removing Photos App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.WindowsAlarms")
        {
            Write-Host "Removing Alarms App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        <#
        If ($App.DisplayName -eq "Microsoft.WindowsCalculator")
        {
            Write-Host "Removing Calculator Store App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        #>

        If ($App.DisplayName -eq "Microsoft.WindowsCamera")
        {
            Write-Host "Removing Camera App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.WindowsMaps")
        {
            Write-Host "Removing Maps App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.WindowsPhone")
        {
            Write-Host "Removing Phone Companion App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }

        If ($App.DisplayName -eq "Microsoft.WindowsSoundRecorder")
        {
            Write-Host "Removing Voice Recorder App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        
        If ($App.DisplayName -eq "Microsoft.Office.Sway")
        {
            Write-Host "Removing Office Sway App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        
        If ($App.DisplayName -eq "Microsoft.Messaging")
        {
            Write-Host "Removing Messaging App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        
        If ($App.DisplayName -eq "Microsoft.ConnectivityStore")
        {
            Write-Host "Removing Connectivity Store helper App..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "Microsoft.Office.OneNote")
        {
            Write-Host "Removing Microsoft Office OneNote..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "Microsoft.MSPaint")
        {
            Write-Host "Removing Microsoft Paint..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
         If ($App.DisplayName -eq "Microsoft.WindowsFeedbackHub")
        {
            Write-Host "Removing Microsoft Windows Feedback Hub..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "microsoft.windowscommunicationsapps")
        {
            Write-Host "Removing Microsoft Communications (Mail & Calendar) Apps..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "Microsoft.WindowsStore")
        {
            Write-Host "Removing Microsoft Windows Store Apps..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "Microsoft.Microsoft3DViewer")
        {
            Write-Host "Removing Microsoft 3D Viwer Apps..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
        If ($App.DisplayName -eq "Microsoft.OneConnect")
        {
            Write-Host "Removing Microsoft OneConnect Apps..." -ForegroundColor Yellow
            Remove-AppxProvisionedPackage -Online -PackageName $App.PackageName | Out-Null
            Remove-AppxPackage -Package $App.PackageName | Out-Null
        }
    }

    Start-Sleep -Seconds 5
    Write-Host ""
}
Write-Host "" -ForegroundColor Cyan
Write-Host "" -ForegroundColor Cyan
Write-Host "Prevent Built-In Apps from Updating/Downloading" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Policies\Microsoft\WindowsStore /v AutoDownload /t REG_DWORD /d 0x2 /f #Turn off Auto Download and Install of Updates
Write-Host "Disabling Windows Consumer Features" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Policies\Microsoft\Windows\CloudContent /f #Disable Windows Consumer Features - create folder if does not exist
reg add HKLM\SOFTWARE\Policies\Microsoft\Windows\CloudContent /v DisableWindowsConsumerFeatures /t REG_DWORD /d 0x1 /f #Disable Windows Consumer Features
Write-Host "Removing Contact Support Capability..." -ForegroundColor Cyan
Remove-WindowsCapability -name "App.Support.ContactSupport~~~~0.0.1.0" -Online
Remove-WindowsCapability -name "App.Support.QuickAssist~~~~0.0.1.0" -Online
Write-Host "==============================REMOVING OF BUILT-IN APP COMPLETE=============================" -ForegroundColor Green

############### Disable Services #######################
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                            DISABLING UNNCESSARY WINDOWS SERVICES                              *" -ForegroundColor Yellow
Write-Host "*                            =====================================                              *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Start-Sleep 1
# Disable Services:
If ($HyperVServices -eq "false")
{
    Write-Host "Disabling Hyper-V Services..." -ForegroundColor cyan
    Set-Service vmickvpexchange -StartupType Disabled
    Set-Service vmicguestinterface -StartupType Disabled
    Set-Service vmicshutdown -StartupType Disabled
    Set-Service vmicheartbeat -StartupType Disabled
    Set-Service vmicvmsession -StartupType Disabled
    Set-Service vmicrdv -StartupType Disabled
    Set-Service vmictimesync -StartupType Disabled
    Set-Service vmicvss -StartupType Disabled
    Set-Service HvHost -StartupType Disabled
}
Write-Host "Disabling AllJoyn Router Service..." -ForegroundColor Cyan
Set-Service AJRouter -StartupType Disabled

Write-Host "Disabling Application Layer Gateway Service..." -ForegroundColor Cyan
Set-Service ALG -StartupType Disabled

If ($AppMgt -eq "false")
{
Write-Host "Disabling Application Management Service..." -ForegroundColor Cyan
Set-Service AppMgmt -StartupType Disabled
}

If ($BITS -eq "false")
{
Write-Host "Disabling Background Intelligent Transfer Service..." -ForegroundColor Cyan
Set-Service BITS -StartupType Disabled
}
Write-Host "Disabling Bitlocker Drive Encryption Service..." -ForegroundColor Cyan
Set-Service BDESVC -StartupType Disabled

Write-Host "Disabling Block Level Backup Engine Service..." -ForegroundColor Cyan
Set-Service wbengine -StartupType Disabled

Write-Host "Disabling Bluetooth Handsfree Service..." -ForegroundColor Cyan
Set-Service BthHFSrv -StartupType Disabled

Write-Host "Disabling Bluetooth Support Service..." -ForegroundColor Cyan
Set-Service bthserv -StartupType Disabled

Write-Host "Branche Cache Service..." -ForegroundColor Cyan
Set-Service PeerDistSvc -StartupType Disabled

Write-Host "Disabling Computer Browser Service..." -ForegroundColor Cyan
Set-Service Browser -StartupType Disabled

Write-Host "Disabling Device Setup Manager Service..." -ForegroundColor Cyan
Set-Service DsmSvc -StartupType Disabled

Write-Host "Disabling Diagnostic Policy Service..." -ForegroundColor Cyan
Set-Service DPS -StartupType Disabled

Write-Host "Disabling Diagnostic Service Host Service..." -ForegroundColor Cyan
Set-Service WdiServiceHost -StartupType Disabled

Write-Host "Disabling Diagnostic System Host Service..." -ForegroundColor Cyan
Set-Service WdiSystemHost -StartupType Disabled

If ($DiagnosticService -eq "False")
{
    Write-Host "Disabling Diagnostics Tracking Service..." -ForegroundColor Cyan
    Set-Service DiagTrack -StartupType Disabled
}
Write-Host "Disabling Distributed Link Tracking Client..." -ForegroundColor Cyan
Set-Service TrkWks -StartupType Disabled

If ($EFS -eq "False")
{
    Write-Host "Disabling Encrypting File System Service..." -ForegroundColor Cyan
    Set-Service EFS -StartupType Disabled
}

If ($EAPService -eq "False")
{
    Write-Host "Disabling Extensible Authentication Protocol Service..." -ForegroundColor Cyan
    Set-Service Eaphost -StartupType Disabled
}

Write-Host "Disabling Fax Service..." -ForegroundColor Cyan
Set-Service Fax -StartupType Disabled

Write-Host "Disabling Function Discovery Provider Host Service..." -ForegroundColor Cyan
Set-Service fdPHost -StartupType Disabled

Write-Host "Disabling Function Discovery Resource Publication Service..." -ForegroundColor Cyan
Set-Service FDResPub -StartupType Disabled


If ($FileHistoryService -eq "False")
{
    Write-Host "Disabling File History Service..." -ForegroundColor Cyan
    Set-Service fhsvc -StartupType Disabled
}

Write-Host "Disabling Geolocation Service..." -ForegroundColor Cyan
Set-Service lfsvc -StartupType Disabled

Write-Host "Disabling Home Group Listener Service..." -ForegroundColor Cyan
Set-Service HomeGroupListener -StartupType Disabled

Write-Host "Disabling Home Group Provider Service..." -ForegroundColor Cyan
Set-Service HomeGroupProvider -StartupType Disabled

Write-Host "Disabling Home Group Provider Service..." -ForegroundColor Cyan
Set-Service HomeGroupProvider -StartupType Disabled

Write-Host "Disabling Internet Connection Sharing (ICS) Service..." -ForegroundColor Cyan
Set-Service SharedAccess -StartupType Disabled

Write-Host "Disabling Infrared Monitoring Service..." -ForegroundColor Cyan
Set-Service irmon -StartupType Disabled

If ($MSSignInService -eq "False")
{
    Write-Host "Disabling Microsoft Account Sign-in Assistant Service..." -ForegroundColor Cyan
    Set-Service wlidsvc -StartupType Disabled
}

If ($iSCSI -eq "False")
{
    Write-Host "Disabling Microsoft iSCSI Initiator Service..." -ForegroundColor Cyan
    Set-Service MSiSCSI -StartupType Disabled
}

Write-Host "Disabling Microsoft Software Shadow Copy Provider Service..." -ForegroundColor Cyan
Set-Service swprv -StartupType Disabled

Write-Host "Disabling Microsoft Storage Spaces SMP Service..." -ForegroundColor Cyan
Set-Service smphost -StartupType Disabled

Write-Host "Disabling Microsoft Maps Download Manager Service..." -ForegroundColor Cyan
Set-Service MapsBroker -StartupType Disabled

Write-Host "Disabling Microsoft Network Connectivty Service..." -ForegroundColor Cyan
Set-Service NcaSvc -StartupType Disabled

Write-Host "Disabling Offline Files Service..." -ForegroundColor Cyan
Set-Service CscService -StartupType Disabled

Write-Host "Disabling Optimize drives Service..." -ForegroundColor Cyan
Set-Service defragsvc -StartupType Disabled

Write-Host "Disabling Phone Service..." -ForegroundColor Cyan
Set-Service PhoneSvc -StartupType Disabled

Write-Host "Disabling Program Compatibility Assistant Service..." -ForegroundColor Cyan
Set-Service PcaSvc -StartupType Disabled

Write-Host "Disabling Payments and NFC/SE Manager Service..." -ForegroundColor Cyan
Set-Service SEMgrSvc -StartupType Disabled

Write-Host "Disabling Radio Management Service..." -ForegroundColor Cyan
Set-Service RmSvc -StartupType Disabled

Write-Host "Disabling Retail Demo Service..." -ForegroundColor Cyan
Set-Service RetailDemo -StartupType Disabled

Write-Host "Disabling Security Service..." -ForegroundColor Cyan
Set-Service wscsvc -StartupType Disabled

Write-Host "Disabling Secure Socket Tunneling Protocol Service..." -ForegroundColor Cyan
Set-Service SstpSvc -StartupType Disabled

Write-Host "Disabling Sensor Data Service..." -ForegroundColor Cyan
Set-Service SensorDataService -StartupType Disabled

Write-Host "Disabling Sensor Monitoring Service..." -ForegroundColor Cyan
Set-Service SensrSvc -StartupType Disabled

Write-Host "Disabling Sensor Service..." -ForegroundColor Cyan
Set-Service SensorService -StartupType Disabled

Write-Host "Disabling Shell Hardware Detection Service..." -ForegroundColor Cyan
Set-Service ShellHWDetection -StartupType Disabled

Write-Host "Disabling SNMP Trap Service..." -ForegroundColor Cyan
Set-Service SNMPTRAP -StartupType Disabled

Write-Host "Disabling Spot Verifier Service..." -ForegroundColor Cyan
Set-Service svsvc -StartupType Disabled

Write-Host "Disabling SSDP Discovery Service..." -ForegroundColor Cyan
Set-Service SSDPSRV -StartupType Disabled

Write-Host "Disabling Telephony Service..." -ForegroundColor Cyan
Set-Service TapiSrv -StartupType Disabled

If ($Themes -eq "False")
{
    Write-Host "Disabling Themes Service..." -ForegroundColor Cyan
    Set-Service Themes -StartupType Disabled
}

Write-Host "Disabling Touch Keyboard and Handwriting Panel Service..." -ForegroundColor Cyan
Set-Service TabletInputService -StartupType Disabled

Write-Host "Disabling UPnP Device Host Service..." -ForegroundColor Cyan
Set-Service upnphost -StartupType Disabled

Write-Host "Disabling Volume Shadow Copy Service..." -ForegroundColor Cyan
Set-Service VSS -StartupType Disabled

Write-Host "Disabling Wi-fi Direct Connect Manager Service..." -ForegroundColor Cyan
Set-Service WFDSConMgrSvc -StartupType Disabled

Write-Host "Disabling Windows Connect Now - Config Registrar Service..." -ForegroundColor Cyan
Set-Service wcncsvc -StartupType Disabled

Write-Host "Disabling Windows Error Reporting Service..." -ForegroundColor Cyan
Set-Service WerSvc -StartupType Disabled

Write-Host "Disabling Windows Media Player Network Sharing Service..." -ForegroundColor Cyan
Set-Service WMPNetworkSvc -StartupType Disabled

Write-Host "Disabling Windows Mobile Hotspot Service..." -ForegroundColor Cyan
Set-Service icssvc -StartupType Disabled

Write-Host "Disabling Windows Update Service..." -ForegroundColor Cyan
Set-Service wuauserv -StartupType Disabled

Write-Host "Disabling WLAN AutoConfig Service..." -ForegroundColor Cyan
Set-Service WlanSvc -StartupType Disabled

Write-Host "Disabling WWAN AutoConfig Service..." -ForegroundColor Cyan
Set-Service WwanSvc -StartupType Disabled

Write-Host "Disabling Xbox Accessories Management Service..." -ForegroundColor Cyan
Set-Service XboxGipSvc -StartupType Disabled

Write-Host "Disabling Xbox Live Auth Manager Service..." -ForegroundColor Cyan
Set-Service XblAuthManager -StartupType Disabled

Write-Host "Disabling Xbox Live Game Save Service..." -ForegroundColor Cyan
Set-Service XblGameSave -StartupType Disabled

Write-Host "Disabling Xbox Live Networking Service Service..." -ForegroundColor Cyan
Set-Service XboxNetApiSvc -StartupType Disabled

Write-Host "==============================DISABLING OF WINDOWS SERVICES COMPLETE=============================" -ForegroundColor Green

Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                            REGISTRY & PERFORMANCE TUNING(OS,SMB,TCP)                          *" -ForegroundColor Yellow
Write-Host "*                            =========================================                          *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Start-Sleep 3
############### Registry Tweaks #######################
Start-Sleep 1
Write-Host "Registry Tweak - Hide VMware Tools Tray Icon" -ForegroundColor Cyan
reg add "HKLM\SOFTWARE\VMware, Inc.\VMware Tools" /v ShowTray /t REG_DWORD /d 0x0 /f # Hide VMware Tray Icon
Write-Host "Registry Tweak - Disabling TCP OffLoading" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters /v DisableTaskOffload /t REG_DWORD /d 0x1 /f #Disables TCP Offloading
Write-Host "Registry Tweak - Hide Action Centre Icon" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer /v HideSCAHealth /t REG_DWORD /d 0x1 /f #Hide Action Center Icon
Write-Host "Registry Tweak - Do not send Administrative alert during system crash" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Control\CrashControl /v SendAlert /t REG_DWORD /d 0x0 /f #Do not send Administrative alert during system crash
Write-Host "Registry Tweak - Increase services startup timeout from 30 to 60 seconds" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Control /v ServicesPipeTimeout /t REG_DWORD /d 0xea60 /f #Increase services startup timeout from 30 to 60 seconds
Write-Host "Registry Tweak - Disable Internet Explorer First RunWizard" -ForegroundColor Cyan
reg add "HKLM\SOFTWARE\Policies\Microsoft\Internet Explorer\Main" /v DisableFirstRunCustomize /t REG_DWORD /d 0x1 /f # Disable Internet Explorer First RunWizard
Write-Host "Registry Tweak - Disable NTFS Last Access Timestamps" -ForegroundColor Cyan
reg add "HKLM\SYSTEM\CurrentControlSet\FileSystem" /v NtfsDisableLastAccessUpdate /t REG_DWORD /d 0x1 /f #Disable NTFS Last Access Timestamps
Write-Host "Registry Tweak - Disable Memory Dump Creation" -ForegroundColor Cyan
reg add "HKLM\SYSTEM\CurrentControlSet\Control\CrashControl" /v CrashDumpEnabled /t REG_DWORD /d 0x0 /f #Disable Memory Dump Creation
Write-Host "Registry Tweak - Disable Memory Dump Send Alert" -ForegroundColor Cyan
reg add "HKLM\SYSTEM\CurrentControlSet\Control\CrashControl" /v LogEvent /t REG_DWORD /d 0x0 /f #Disable Memory Dump Creation
Write-Host "Registry Tweak - Increase Disk I/O Timeout to 200 Seconds" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Services\Disk /v TimeOutValue /t REG_DWORD /d 0xc8 /f #Increase Disk I/O Timeout to 200 Seconds
Write-Host "Registry Tweak - Disable default system Screensaver" -ForegroundColor Cyan
reg add "HKU\.DEFAULT\Control Panel\Desktop" /v ScreenSaveActive /t REG_DWORD /d 0x0 /f #Disable default system Screensaver
Write-Host "Registry Tweak - Hide Hard Error Messages" -ForegroundColor Cyan
reg add HKLM\System\CurrentControlSet\Control\Windows /v ErrorMode /t REG_DWORD /d 0x2 /f #Hide Hard Error Messages
Write-Host "Registry Tweak - Record only Errors in Printer Eventlog" -ForegroundColor Cyan
reg add HKLM\System\CurrentControlSet\Control\Print\Providers /v EventLog /t REG_DWORD /d 0x1 /f #Record only Errors in Printer Eventlog
Write-Host "Registry Tweak - Disable Paging of the Executive" -ForegroundColor Cyan
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v DisablePagingExecutive /t REG_DWORD /d 0x1 /f #Paging of the Executive
Write-Host "Registry Tweak - Disable Offline Files and Folders" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\NetCache /v Enabled /t REG_DWORD /d 0x0 /f #Disable Offline Files and Folders
Write-Host "Registry Tweak - Disable Defrag" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Microsoft\Dfrg\BootOptimizeFunction /v Enable /t REG_SZ /d N /f # Disable Defrag
Write-Host "Registry Tweak - Disable Machine Account Password Change" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Services\Netlogon\Parameters /v DisablePasswordChange /t REG_DWORD /d 0x1 /f #Disable Machine Password Change
Write-Host "Registry Tweak - Disable CIFS Change Notification" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer /v NoRemoteRecursiveEvents /t REG_DWORD /d 0x0 /f # Disables CIFS Change Notification
Write-Host "Registry Tweak - Increase Worker thread to increase I/O Performance" -ForegroundColor Cyan
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Executive" /v AdditionalCriticalWorkerThreads /t REG_DWORD /d 0x64 /f #Increase Worker thread to increase I/O Performance
Write-Host "Registry Tweak - Disable Windows 10 Logon Animation" -ForegroundColor Cyan
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" /v EnableFirstLogonAnimation /t REG_DWORD /d 0x0 /f # Disable Windows 10 Logon Animation
Write-Host "Registry Tweak - Disable Background Defrag" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\OptimalLayout /v EnableAutoLayout /t REG_DWORD /d 0x0 /f # Disable Background Defrag
# Modify File Explorer/My Computer 
If ($ShowQuickAccess -eq "False")
{
Write-Host "Registry Tweak - Take Ownership/Permisson of Quick Access Folder" -ForegroundColor Cyan
cd C:\temp\OptimisationScript
Start-Process RemoveQuickAccessandNetwork.bat
Start-Sleep 5
Write-Host "Registry Tweak - Remove Quick Access from File Explorer" -ForegroundColor Cyan
reg add "HKCR\CLSID\{679f85cb-0220-4080-b29b-5540cc05aab6}\ShellFolder" /v Attributes /t REG_DWORD /d 2690646016 /f #Removes Quick Access from File Explorer
}

If ($ShowNetworkicon -eq "False")
{
Write-Host "Registry Tweak - Take Ownership/Permisson of Network Shell Folder" -ForegroundColor Cyan
cd C:\temp\OptimisationScript
Start-Process RemoveQuickAccessandNetwork.bat
Start-Sleep 5
Write-Host "Registry Tweak - Remove Network from File Explorer" -ForegroundColor Cyan
reg add "HKCR\CLSID\{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}\ShellFolder" /v Attributes /t REG_DWORD /d 2962489444 /f #Removes Network Icon from File Exploer Panel
reg add "HKCR\CLSID\Wow6432Node\{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}\ShellFolder" /v Attributes /t REG_DWORD /d 2962489444 /f #Removes Network Icon from File Exploer Panel
}

Write-Host "Registry Tweak - Removing Suggested Apps/Content Delivert/Pre-installed Apps...." -ForegroundColor Cyan
Reg Add "HKCU\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "SystemPaneSuggestionsEnabled" /D 0 /F
Reg Add "HKCU\Software\Microsoft\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "SoftLandingEnabled" /D 0 /F
Reg Add "HKCU\Software\Microsoft\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "RotatingLockScreenEnable" /D 0 /F
Reg Add "HKCU\Software\Microsoft\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "PreInstalledAppsEnabled" /D 0 /F
Reg Add "HKCU\Software\Microsoft\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "SilentInstalledAppsEnabled" /D 0 /F
Reg Add "HKCU\Software\Microsoft\CurrentVersion\ContentDeliveryManager\" /T REG_DWORD /V "ContentDeliveryAllowed" /D 0 /F

If ($AllowOneDrive -eq "false")
{
Write-Host "Registry Tweak - Prevent OneDrive Sync/Access" -ForegroundColor Cyan
reg add HKLM\SOFTWARE\Policies\Microsoft\Windows\OneDrive /f #Prevent OneDrive file sync
reg add HKLM\SOFTWARE\Policies\Microsoft\Windows\OneDrive /v DisableFileSyncNGSC /t REG_DWORD /d 0x1 /f # Disable OneDrive
}

# Modify Start Menu
If ($ShowAdmintools -eq "false")
{
Write-Host "Start Menu - Hiding Administrative Tools for Non-Admins" -ForegroundColor Cyan
icacls "C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Administrative Tools" /INHERITANCE:d
icacls "C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Administrative Tools" /REMOVE "EVERYONE"
icacls "C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Administrative Tools" /REMOVE "BUILTIN\USERS"
}
If ($ShowCmdandPowershell -eq "false")
{
Write-Host "Start Menu - Removing Command Prompt from Start Menu" -ForegroundColor Cyan
Remove-item "C:\Users\Default\Appdata\Roaming\Microsoft\Windows\Start Menu\Programs\System Tools\Command Prompt.lnk" -Confirm:$false
Write-Host "Start Menu - Removing Powershell from Start Menu" -ForegroundColor Cyan
Remove-item "C:\Users\Default\Appdata\Roaming\Microsoft\Windows\Start Menu\Programs\Windows powershell" -recurse -force
}

#SMB Tuning
Write-Host "SMB Tuning - Adjusting Directory Cache" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v DirectoryCacheEntriesMax /t REG_DWORD /d 0x4096 /f #Directory Cache, increased to improve performance/Network when Directory when accessing Large Directories
Write-Host "SMB Tuning  - Adjusting File Information Cache" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v FileNotFoundCacheEntriesMax /t REG_DWORD /d 0x32768 /f #File Information Cache, increased to improve performance/Network when Directory when accessing Large Directories
Write-Host "Start Menu - Adjusting of Outstanding requests for a session" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v MaxCmds /t REG_DWORD /d 0x2048 /f #Limits number of outstanding request for a session
Write-Host "SMB Tuning - Adjusting Metadata info Cache" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v FileInfoCacheEntriesMax /t REG_DWORD /d 0x32768 /f #Metadata info Cache, increased to improve performance/Network when Directory when accessing Large Directories
Write-Host "SMB Tuning - Enabling Large MTU" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v DisableLargeMtu /t REG_DWORD /d 0x0 /f # Enable Large MTU
Write-Host "SMB Tuning - Disable Bandwidth Throttling" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v DisableBandwidthThrottling /t REG_DWORD /d 0x1 /f #Disable Bandwidth Throttling
Write-Host "SMB Tuning - Disabling Opportunistic Locking" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v EnableOplocks /t REG_DWORD /d 0x0 /f # Disable Opportunistic Locking
Write-Host "SMB Tuning - Do no use Opportunistic Locking" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanWorkstation\Parameters /v UseOpportunisticLocking /t REG_DWORD /d 0x0 /f #Do Not Use Opportunistic Locking
Write-Host "SMB Tuning - Adjusting Number of outstanding requests" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanServer\Parameters /v MaxMpxCt /t REG_DWORD /d 0x2048 /f #Number of outstanding requests on a session
Write-Host "SMB Tuning - Adjusting Max Work Items" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanServer\Parameters /v MaxWorkItems /t REG_DWORD /d 0x16384 /f #Max Work Items
Write-Host "SMB Tuning - Adjusting Max Raw Work Items" -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\services\LanmanServer\Parameters /v MaxRawWorkItems /t REG_DWORD /d 0x512 /f #Max Raw Work Items
Write-Host "SMB Tuning - Disable NTFS 8dot3NameCreation " -ForegroundColor Cyan
reg add HKLM\SYSTEM\CurrentControlSet\Services\Lanmanworkstation\Parameters /v NTFSDisable8dot3NameCreation /t REG_DWORD /d 0x1 /f # Disable Dot3Name Creation
#TCP Tuning
Write-Host "TCP Tuning - Disable TCP Autotuning " -ForegroundColor Cyan
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v TcpAutotuning /t REG_DWORD /d 0x0 /f # Disable TCP Autotuning
reg add "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Internet Settings" /v TcpAutotuning /t REG_DWORD /d 0x0 /f # Disable TCP Autotunning
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\WinHttp" /v TcpAutotuning /t REG_DWORD /d 0x0 /f # Disable TCP Autotunning
Write-Host "TCP Tuning - Disable TCP RSS " -ForegroundColor Cyan
netsh int tcp set global rss=disabled
#ActiveSetup - Speeds up login for users
Write-Host "ActiveSetup - Prevent Windows Themes Running - 32bit " -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{2C7339CF-2B09-4501-B3F3-F3508C9228ED}" /v StubPath /f # Themes
Write-Host "ActiveSetup - Prevent Windows Mail Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{44BBA840-CC51-11CF-AAFA-00AA00B6015C}" /v StubPath /f # Windows Mail
Write-Host "ActiveSetup - Prevent Windows Media Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{6BF52A52-394A-11d3-B153-00C04F79FAA6}" /v StubPath /f # Windows Media
Write-Host "ActiveSetup - Prevent Windows Media Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\>{22d6f312-b0f6-11d0-94ab-0080c74c7e95}" /v StubPath /f # Windows Media
Write-Host "ActiveSetup - Prevent Windows Desktop Update Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4340}" /v StubPath /f # Windows Desktop Update
Write-Host "ActiveSetup - Prevent Windows Web Platform Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4383}" /v StubPath /f #Web Platform
Write-Host "ActiveSetup - Prevent Windows DotNet Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{89B4C1CD-B018-4511-B0A1-5476DBF70820}" /v StubPath /f #DotNet
Write-Host "ActiveSetup - Prevent Windows IE for Admins Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A7-37EF-4b3f-8CFC-4F3A74704073}" /v StubPath /f #IE for Admins
Write-Host "ActiveSetup - Prevent Windows IE for Users Running - 32bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A8-37EF-4b3f-8CFC-4F3A74704073}" /v StubPath /f #IE for Users
Write-Host "ActiveSetup - Prevent Windows Themes Running - 64bit " -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{2C7339CF-2B09-4501-B3F3-F3508C9228ED}" /v StubPath /f # Themes
Write-Host "ActiveSetup - Prevent Windows Mail Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{44BBA840-CC51-11CF-AAFA-00AA00B6015C}" /v StubPath /f # Windows Mail
Write-Host "ActiveSetup - Prevent Windows Media Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{6BF52A52-394A-11d3-B153-00C04F79FAA6}" /v StubPath /f # Windows Media
Write-Host "ActiveSetup - Prevent Windows Media Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\>{22d6f312-b0f6-11d0-94ab-0080c74c7e95}" /v StubPath /f # Windows Media
Write-Host "ActiveSetup - Prevent Windows Desktop Update Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4340}" /v StubPath /f # Windows Desktop Update
Write-Host "ActiveSetup - Prevent Windows Web Platform Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4383}" /v StubPath /f #Web Platform
Write-Host "ActiveSetup - Prevent Windows DotNet Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{89B4C1CD-B018-4511-B0A1-5476DBF70820}" /v StubPath /f #DotNet
Write-Host "ActiveSetup - Prevent Windows IE for Admins Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWAREWow6432Node\\Microsoft\Active Setup\Installed Components\{A509B1A7-37EF-4b3f-8CFC-4F3A74704073}" /v StubPath /f #IE for Admins
Write-Host "ActiveSetup - Prevent Windows IE for Users Running - 64bit" -ForegroundColor Cyan
reg delete "HKLM\SOFTWARE\Wow6432Node\Microsoft\Active Setup\Installed Components\{A509B1A8-37EF-4b3f-8CFC-4F3A74704073}" /v StubPath /f #IE for Users
Write-Host "==============================REGISTRY TWEAKING/TUNNING COMPLETE=================================" -ForegroundColor Green
Write-Host "                                                                                                 " -ForegroundColor Yellow
Write-Host "                                                                                                 " -ForegroundColor Yellow
Write-Host "                                                                                                 " -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                            DISABLING UNCESSARY SCHEDULED TASKS                                *" -ForegroundColor Yellow
Write-Host "*                            =====================================                              *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Start-Sleep 3
############### Disable Scheduled Tasks #######################
Start-Sleep 1
Write-Host "Disabling Scheduled Tasks..." -ForegroundColor Cyan
Write-Host ""
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Application Experience\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\AppID\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Autochk\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Customer Experience Improvement Program\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Bluetooth\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\ApplicationData\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\CHKDSK\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Diagnosis\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\DiskDiagnostic\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\FileHistory\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Maintenance\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Power Efficiency Diagnostics\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\RecoveryEnvironment\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Registry\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Mobile Broadband Accounts\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\RAS\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\WDI\" | Disable-ScheduledTask
Disable-ScheduledTask -TaskName "IndexerAutomaticMaintenance" -TaskPath "\Microsoft\Windows\Shell"
Disable-ScheduledTask -TaskName "FamilySafetyMonitor" -TaskPath "\Microsoft\Windows\Shell"
Disable-ScheduledTask -TaskName "FamilySafetyRefreshTask" -TaskPath "\Microsoft\Windows\Shell"
Get-ScheduledTask -TaskPath "\Microsoft\XblGameSave\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Maps\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\MemoryDiagnostic\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Location\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Active Directory Rights Management Services Client\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Windows Error Reporting\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Offline Files\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\WindowsUpdate\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Speech\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Windows Filtering Platform\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\SystemRestore\" | Disable-ScheduledTask
Get-ScheduledTask -TaskPath "\Microsoft\Windows\Windows Defender\" | Disable-ScheduledTask
Write-Host "==============================DISABLING OF SCHEDULED TASKS COMPLETE==============================" -ForegroundColor Green
Write-Host "                                                                                                " -ForegroundColor Yellow
Write-Host "                                                                                                " -ForegroundColor Yellow
Write-Host "                                                                                                " -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*                                     OPTIMISING POWER OPTIONS                                  *" -ForegroundColor Yellow
Write-Host "*                                   ============================                                *" -ForegroundColor Yellow
Write-Host "*                                                                                               *" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Yellow
Start-Sleep 3
#Disable Hibernate & Set Power Option
Start-Sleep 1
# Set VM to High Perf scheme:
Write-Host "Switching Off Hibernate..." -ForegroundColor Cyan
Write-Host ""
Powercfg -h off
Write-Host "Setting VM to High Performance Power Scheme..." -ForegroundColor Cyan
Write-Host ""
Try {
        $HighPerf = powercfg -l | %{if($_.contains("High performance")) {$_.split()[3]}}
        $CurrPlan = $(powercfg -getactivescheme).split()[3]
        if ($CurrPlan -ne $HighPerf) {powercfg -setactive $HighPerf}
    } Catch {
        Write-Warning -Message "Unable to set power plan to high performance"
    }
Start-Sleep 3
Write-Host "==============================ADJUSTING OF POWER OPTIONS COMPLETE================================" -ForegroundColor Red
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
Write-Host "*************************************************************************************************" -ForegroundColor Green
Write-Host "*                                                                                               *" -ForegroundColor Green
Write-Host "*      ALL WINDOWS 10 VDI OPTIMISAITON ARE NOW COMPLETE.YOUR SYSTEM WILL REBOOT IN 5 SECONDS.   *" -ForegroundColor Green
Write-Host "*                                                                                               *" -ForegroundColor Green
Write-Host "*************************************************************************************************" -ForegroundColor Green
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
Write-Host "" -ForegroundColor Yellow
shutdown -r -t 5